//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------



#ifndef _TYPES_H_
#define _TYPES_H_

#include <cpctelera.h>

typedef struct Prop{

	u8 xPos;
	u8 yPos;
	u8 type;

} Prop;

typedef struct Keys{
    
    cpct_keyID up;
    cpct_keyID down;
    cpct_keyID left;
    cpct_keyID right;
    cpct_keyID fire;
    cpct_keyID pause;
    cpct_keyID abort;
    
} Keys;

typedef struct Entity{
    
	u8 type;
	u8 hits;
    i8 xPos;
    u8 yPos;
    u8 width;
    u8 height;
    i8 pxPos;
    u8 pyPos;
    u8 state;
    u8 pstate;
    i8 xSpeed;
    u8 cycles;
    u8 bullet;
    u8 *frame1;
    u8 *frame2;
    u8 *frame3;
    u8 *frame4;
    u8 *frame5;
    u8 *frame6;
    u8 *frame7;
    u8 *frame8;
    u8 lastTile;
    u8 window;
    
} Entity;

typedef struct Bullet{
    
    i8 xPos;
    u8 yPos;
    i8 pxPos;
    u8 pyPos;
    u8 active;
    u8 pactive;
    i8 xSpeed;
    u8 ySpeed;
    u8 cycles;
    
} Bullet;


typedef struct Coords{
    i8 xPos;
    u8 yPos;
} Coords;


typedef struct Respawn{

	u8 type;
	Coords coords;
	i8 direction;

} Respawn;

#endif
